<?php
/**
 * Uninstall-Skript für Jenva Backup & Migration
 * 
 * Wird ausgeführt, wenn das Plugin gelöscht wird
 */

// Direkten Zugriff verhindern
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Optionen löschen
delete_option('jbm_settings');
delete_option('jbm_schedule');

// Geplante Events löschen
wp_clear_scheduled_hook('jbm_scheduled_backup');

// Datenbanktabelle löschen
global $wpdb;
$table_name = $wpdb->prefix . 'jbm_backups';
$wpdb->query($wpdb->prepare("DROP TABLE IF EXISTS `%s`", esc_sql($table_name)));

// Backup-Verzeichnis löschen (optional - kann auskommentiert werden)
// Achtung: Dies löscht alle Backups!
/*
$backup_dir = WP_CONTENT_DIR . '/jenva-backup-migration/';
if (is_dir($backup_dir)) {
    // Rekursiv löschen
    $files = new RecursiveIteratorIterator(
        new RecursiveDirectoryIterator($backup_dir, RecursiveDirectoryIterator::SKIP_DOTS),
        RecursiveIteratorIterator::CHILD_FIRST
    );
    
    foreach ($files as $file) {
        if ($file->isDir()) {
            rmdir($file->getRealPath());
        } else {
            unlink($file->getRealPath());
        }
    }
    
    rmdir($backup_dir);
}
*/

// Transients löschen
$wpdb->query(
    $wpdb->prepare(
        "DELETE FROM `%s` WHERE option_name LIKE %s OR option_name LIKE %s",
        esc_sql($wpdb->options),
        '_transient_jbm_%',
        '_transient_timeout_bmp_%'
    )
);

